SET NOEXEC OFF
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON

IF [dbo].[ISSAM4]() = 1
  BEGIN
    SET NOEXEC ON
  END
GO

SET QUOTED_IDENTIFIER ON

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDDiaryAttachments')
  BEGIN
    SELECT DAT.*
      INTO [dbo].[ORPHANEDDiaryAttachments]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                      INNER JOIN [dbo].[DiaryAttachments] DAT
                              ON DAT.[DIARYID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DAT
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                      INNER JOIN [dbo].[DiaryAttachments] DAT
                              ON DAT.[DIARYID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDDiaryAttachments2')
  BEGIN
    SELECT DAT.*
      INTO [dbo].[ORPHANEDDiaryAttachments2]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[DiaryAttachments] DAT
                   ON DAT.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DAT
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[DiaryAttachments] DAT
                   ON DAT.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDDiaryDelegations')
  BEGIN
    SELECT DEL.*
      INTO [dbo].[ORPHANEDDiaryDelegations]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                      INNER JOIN [dbo].[DiaryDelegations] DEL
                              ON DEL.[ACTIONID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DEL
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                      INNER JOIN [dbo].[DiaryDelegations] DEL
                              ON DEL.[ACTIONID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDDiary')
  BEGIN
    SELECT DIA.*
      INTO [dbo].[ORPHANEDDiary]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DIA
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDCaseUDFAnswers')
  BEGIN
    SELECT CUF.*
      INTO [dbo].[ORPHANEDCaseUDFAnswers]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[CaseUDFAnswers] CUF
                   ON CUF.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE CUF
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[CaseUDFAnswers] CUF
                   ON CUF.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDMatterLedger')
  BEGIN
    SELECT MAL.*
      INTO [dbo].[ORPHANEDMatterLedger]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[MatterLedger] MAL
                   ON MAL.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE MAL
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[MatterLedger] MAL
                   ON MAL.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDTimeEntry')
  BEGIN
    SELECT TIE.*
      INTO [dbo].[ORPHANEDTimeEntry]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[TimeEntry] TIE
                   ON TIE.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE TIE
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[TimeEntry] TIE
                   ON TIE.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDTimeDaybook')
  BEGIN
    SELECT TDB.*
      INTO [dbo].[ORPHANEDTimeDaybook]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[TimeDayBook] TDB
                   ON TDB.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE TDB
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[TimeDayBook] TDB
                   ON TDB.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDUndertakings')
  BEGIN
    SELECT UND.*
      INTO [dbo].[ORPHANEDUndertakings]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[Undertakings] UND
                   ON UND.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE UND
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[Undertakings] UND
                   ON UND.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDBillDetails')
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        SELECT BD.*
          INTO [dbo].[ORPHANEDBillDetails]
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillHeader] BH
                          INNER JOIN [dbo].[BillDetails] BD
                                  ON BD.[DRAFTNO] = BH.[DRAFTNO]
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL

        DELETE BD
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillHeader] BH
                          INNER JOIN [dbo].[BillDetails] BD
                                  ON BD.[DRAFTNO] = BH.[DRAFTNO]
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL
      END
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDBillLogging')
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        SELECT BL.*
          INTO [dbo].[ORPHANEDBillLogging]
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillHeader] BH
                          INNER JOIN [dbo].[BillLogging] BL
                                  ON BL.[DRAFTNO] = BH.[DRAFTNO]
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL

        DELETE BL
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillHeader] BH
                          INNER JOIN [dbo].[BillLogging] BL
                                  ON BL.[DRAFTNO] = BH.[DRAFTNO]
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL
      END
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDBillFeeBreakDown')
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        SELECT BF.*
          INTO [dbo].[ORPHANEDBillFeeBreakDown]
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillFeeBreakDown] BF
                       ON BF.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL

        DELETE BF
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillFeeBreakDown] BF
                       ON BF.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL
      END
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDBillHeader')
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        SELECT BH.*
          INTO [dbo].[ORPHANEDBillHeader]
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillHeader] BH
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL

        DELETE BH
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BillHeader] BH
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL
      END
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDBatchDetails')
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        SELECT BD.*
          INTO [dbo].[ORPHANEDBatchDetails]
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BatchH] BH
                          INNER JOIN [dbo].[BatchDetails] BD
                                  ON BD.[BATCHNO] = BH.[BATCHNO]
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL

        DELETE BD
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BatchH] BH
                          INNER JOIN [dbo].[BatchDetails] BD
                                  ON BD.[BATCHNO] = BH.[BATCHNO]
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL
      END
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDBatchH')
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        SELECT BH.*
          INTO [dbo].[ORPHANEDBatchH]
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BatchH] BH
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL

        DELETE BH
          from [dbo].[CaseMaster] CSM
               LEFT OUTER JOIN [dbo].[matters] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[BatchH] BH
                       ON BH.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL
      END
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDCaseMaster')
  BEGIN
    SELECT CSM.*
      INTO [dbo].[ORPHANEDCaseMaster]
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
     WHERE MAT.[Code] IS NULL

    DELETE CSM
      from [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
     WHERE MAT.[Code] IS NULL
  END

  DELETE CLS
    from [dbo].[Closed] CLS
         INNER JOIN [dbo].[matters] MAT
                 ON MAT.[Code] = CLS.[CODE]
   WHERE CLS.[CODE] = 'ZZZZZZ/ZZZZ'
     AND MAT.[Code] IS NOT NULL

  DELETE CLS
    from [dbo].[CaseMasterClosed] CLS
         INNER JOIN [dbo].[matters] MAT
                 ON MAT.[Code] = CLS.[CSCODE]
   WHERE CLS.[CSCODE] = 'ZZZZZZ/ZZZZ'
     AND MAT.[Code] IS NOT NULL


  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDCloseDiaryAttachments')
  BEGIN
    SELECT DAT.*
      INTO [dbo].[ORPHANEDCloseDiaryAttachments]
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                      INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                              ON DAT.[DIARYID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DAT
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                      INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                              ON DAT.[DIARYID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDCloseDiaryAttachments2')
  BEGIN
    SELECT DAT.*
      INTO [dbo].[ORPHANEDCloseDiaryAttachments2]
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                   ON DAT.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DAT
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                   ON DAT.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDCloseDiaryDelegations')
  BEGIN
    SELECT DEL.*
      INTO [dbo].[ORPHANEDCloseDiaryDelegations]
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                      INNER JOIN [dbo].[DiaryDelegations] DEL
                              ON DEL.[ACTIONID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DEL
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                      INNER JOIN [dbo].[DiaryDelegations] DEL
                              ON DEL.[ACTIONID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDCloseDiary')
  BEGIN
    SELECT DIA.*
      INTO [dbo].[ORPHANEDCloseDiary]
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE DIA
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDClosedCaseUDFAnswers')
  BEGIN
    SELECT CUF.*
      INTO [dbo].[ORPHANEDClosedCaseUDFAnswers]
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[ClosedCaseUDFAnswers] CUF
                   ON CUF.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL

    DELETE CUF
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[ClosedCaseUDFAnswers] CUF
                   ON CUF.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
       AND MAT.[Code] IS NULL
  END
   
  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDClosedMatterLedger')
  BEGIN
    IF [dbo].[ISSAM4]() = 0
      BEGIN
        SELECT MAL.*
          INTO [dbo].[ORPHANEDClosedMatterLedger]
          from [dbo].[CaseMasterClosed] CSM
               LEFT OUTER JOIN [dbo].[Closed] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[ClosedMatterLedger] MAL
                       ON MAL.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL

        DELETE MAL
          from [dbo].[CaseMasterClosed] CSM
               LEFT OUTER JOIN [dbo].[Closed] MAT
                            ON MAT.[Code] = CSM.[CSCODE]
               INNER JOIN [dbo].[ClosedMatterLedger] MAL
                       ON MAL.[MATTER] = CSM.[CSCODE]
         WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) NOT IN ('~', '')
           AND MAT.[Code] IS NULL
      END
  END

  IF NOT EXISTS
    (SELECT *
       FROM SYS.[objects] SO
      WHERE SO.[name] = 'ORPHANEDClosedCaseMaster')
  BEGIN
    SELECT CSM.*
      INTO [dbo].[ORPHANEDClosedCaseMaster]
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
     WHERE MAT.[Code] IS NULL

    DELETE CSM
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
     WHERE MAT.[Code] IS NULL
  END

  DELETE CLS
    from [dbo].[Closed] CLS
         INNER JOIN [dbo].[Closed] MAT
                 ON MAT.[Code] = CLS.[CODE]
   WHERE CLS.[CODE] = 'ZZZZZZ/ZZZZ'
     AND MAT.[Code] IS NOT NULL

  DELETE CLS
    from [dbo].[CaseMasterClosed] CLS
         INNER JOIN [dbo].[Closed] MAT
                 ON MAT.[Code] = CLS.[CSCODE]
   WHERE CLS.[CSCODE] = 'ZZZZZZ/ZZZZ'
     AND MAT.[Code] IS NOT NULL

GO

SET NOEXEC OFF